
#include <windows.h>
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>
#include "host.h"

int16_t _connect(void** handle, int16_t connection_type, void* params)
{
    HANDLE  Handle;
    DCB     PortDCB;
    COMMTIMEOUTS CommTimeouts;
    char port[50];

    //this example supports serial port only
    (void)connection_type;
    RS232_params* port_params = (RS232_params*) params;

    strcpy(port, "\\\\.\\");
    strcat(port, port_params->com);

    //open port
    Handle = CreateFileA(port, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, NULL);
    if ((Handle == INVALID_HANDLE_VALUE))
    {
        return (-1);
    }

    //Modify port parameters
    PortDCB.DCBlength = sizeof(PortDCB);
    if (!GetCommState(Handle, &PortDCB))
    {
        return (-1);
    }
    PortDCB.BaudRate = port_params->baudrate;
    //this example will not support flow control and databits settings different from default
    (void)port_params->dataBits;
    PortDCB.ByteSize = 8;
    (void)port_params->flowControl;
    PortDCB.fOutX = false;
    PortDCB.fInX = false;
    PortDCB.fDtrControl = DTR_CONTROL_DISABLE;
    PortDCB.fRtsControl = RTS_CONTROL_DISABLE;
    switch (port_params->stopBits)
    {
        case 2:
            PortDCB.StopBits = TWOSTOPBITS;
            break;
        case 1:
        default:
            PortDCB.StopBits = ONESTOPBIT;
    }
    switch(port_params->parity)
    {
        case 1:
            PortDCB.Parity = ODDPARITY;
            break;
        case 2:
            PortDCB.Parity = EVENPARITY;
            break;
        default: 
        case 0:
            PortDCB.Parity = NOPARITY;
            break;
    }
    PortDCB.fNull    = false;
    if (!SetCommState(Handle, &PortDCB))
    {
        return (-1);
    }

    //Modify port timeout values
    if (!GetCommTimeouts(Handle, &CommTimeouts))
    {
        return (-1);
    }
    CommTimeouts.WriteTotalTimeoutConstant = 5000;
    CommTimeouts.WriteTotalTimeoutMultiplier = 0;
    CommTimeouts.ReadIntervalTimeout = 0; 
    CommTimeouts.ReadTotalTimeoutConstant = 50;
    CommTimeouts.ReadTotalTimeoutMultiplier = 0;

    if(!SetCommTimeouts(Handle, &CommTimeouts))
    {
        return (-1);
    }

    //purge input buffer
    if (!PurgeComm(Handle, PURGE_RXCLEAR))
    {
        return (-1);
    }

    *handle = Handle;
    return (0);
}

int16_t _disconnect(void* handle)
{
    if(!CloseHandle((HANDLE)handle))
    {
        return (-1);
    }
    return (0);
}

int16_t _tx(void* port_handle, uint8_t* data, uint32_t len)
{
    DWORD bytesWritten = 0;

    if (!WriteFile((HANDLE)port_handle, data, len, &bytesWritten, NULL))
    {
        return (-1);
    }
    else
    {
        if (bytesWritten != len)
        {
            return (-1);
        }
        return (0);
    }
}

int16_t _rx(void* port_handle, uint8_t* data, uint32_t len, uint32_t ms_timeout)
{
    COMMTIMEOUTS CommTimeouts;
    int64_t i = 0;
    int64_t bytesToRead = len;
    DWORD bytesReceived = 0;

    //Modify port timeout values
    if (!GetCommTimeouts((HANDLE)port_handle, &CommTimeouts))
    {
        return (-1);
    }
    if (ms_timeout != 0)
    {
        CommTimeouts.ReadTotalTimeoutMultiplier = 0;
        CommTimeouts.ReadIntervalTimeout = ms_timeout;
        CommTimeouts.ReadTotalTimeoutConstant = ms_timeout;
    }
    else
    {
        CommTimeouts.ReadTotalTimeoutMultiplier = 0;
        CommTimeouts.ReadIntervalTimeout = MAXDWORD;
        CommTimeouts.ReadTotalTimeoutConstant = 0;
    }
    if (!SetCommTimeouts((HANDLE)port_handle, &CommTimeouts))
    {
        return (-1);
    }
    
    //Get data
    while (1)
    {
        if (ReadFile((HANDLE)port_handle, &data[i], (DWORD)bytesToRead, &bytesReceived, NULL))
        {
            if (bytesReceived == 0)
            {
                return (-1);
            }
            i += (int64_t)bytesReceived;
            bytesToRead -= (int64_t)bytesReceived;
            if (bytesToRead == 0) return (0);
            else if (bytesToRead < 0) return (-1); //should never happen..
            bytesReceived = 0;
        }
        else
        {
            return (-1);
        }
    }
}

int16_t _clear_rx_data(void* handle)
{
    if(!PurgeComm((HANDLE)handle, PURGE_RXCLEAR))
    {
        return (-1);
    }
    return (0);
}

void _enable_irqs()
{
    ;
}

void _disable_irqs()
{
    ;
}

uint64_t get_ms_timestamp()
{
    return (uint64_t)timeGetTime();
}